define([
    'underscore',
    'marionette',

    'text!modules/appointments/cancellation/cancellation-control.html',

    'modules/appointments/cancellation/cancellation-popup-view',
], function(
    _,
    Marionette,
    template,
    CancellationWarningPopup
) {
    'use strict';

    return Marionette.View.extend({
        template: _.template(template),
        events: {'click .cancel-btn': 'cancelAppointment'},
        initialize: function(options) {
            var el;

            this._modelType = options.modelType;

            el = options.elAfterCancellation;
            if (
                typeof el === 'string' ||
                el instanceof Node ||
                el instanceof HTMLElement ||
                el instanceof jQuery
            ) {
                this.elAfterCancellation = el;
            } else {
                // eslint-disable-next-line max-len
                throw new Error('Element after cancellation must be specified as a selector string, DOM Node, HTML Element, or a jQuery object');
            }
        },
        cancelAppointment: function(e) {
            var cancellationWarning = new CancellationWarningPopup({
                id: this._modelType + '-cancellation',
                modelType: this._modelType,
                elAfterClose: e.currentTarget,
            });

            cancellationWarning.once('appointment:cancel:confirmed', function() {
                if (typeof gas !== 'undefined') {
                    gas('send', 'event', 'veteran-appointment', 'user-cancelled-appointment-requested');
                }
                this.saveCancelledAppointment().done(this.onSaveCancelledAppointment.bind(this));
            }, this);
            cancellationWarning.once('close', function() {
                cancellationWarning.off(null, null, this);
            }, this);

            cancellationWarning.openPopup();
        },
        onSaveCancelledAppointment: function() {
            var $el;

            if (typeof gas !== 'undefined') {
                gas('send', 'event', 'veteran-appointment', 'user-cancelled-appointment-successful');
            }

            if (typeof this.elAfterCancellation === 'string') {
                $el = $(this.elAfterCancellation);
            } else {
                $el = this.elAfterCancellation;
            }

            $el.focus();
        },
        templateContext: function() {
            return {
                modelType: this._modelType,
                toTitleCase: function(string) {
                    return string.replace(/\w*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                },
            };
        },
    });
}
);
